include <BrickPattern-for-OpenSCAD/brickpattern.scad>;
include <Chamfers-for-OpenSCAD/Chamfer.scad>;

function toInches(dimension) = dimension * 25.4;

MMtoInches = 25.4;
HOScale = 1/87;
epsilon = 0.002;

// Stall 1 Floor Data
FloorThicknessAtWall = 7;
InteriorFloorThickness = 15.7;
StallAngle = 6.347;
PostFaceAngle = StallAngle/2;

// Front Wall Data
BrickLength = 7.5;
BrickHeight = 2.5;
BrickDepth = 3.5;
BrickWidth = 0.5;
MortarWidth = 0.5;
WallThickness = 16;
HeadJambWidth = 3;
SideJambWidth = 4;
SillWidth = 3;
UpperSashWidth = 3;
TopRailWidth = 2.5;
BottomRailWidth = 2.5;
StileWidth = 2.5;
MuntinWidth = 2;
PostDepth = 8;
JambDepth = 8.5;
StileDepth = 2.5;
MuntinDepth = 2;
FrontWallDecorationHeight = 6;
FrontWallDecorationDepth = 3;
FrontWallRecess = 6;
FrontWallHeight = 246;
StallOpeningWidth = 178;
StallOpeningHeight = 213;
PostSpacing = 188;
InsideWallLength = 205.3906;
Stall1FrontWallLength = 195.3949;
PostWidthAtDoors = 25.029;
PostThicknessAtDoors = 11.5;
PostThicknesBetweenDoors = 17.5;

// Lean-To Floor Data
OfficeEndWallLength = 134;
OfficeWallPos = 420.5;
ToolRoomWallPos = 423.5;
LeanToInteriorWallThickness = 6;
MatlRoomWallThickness = 11;
Stall17LeanToBackWallAngle = 95.5884;
Stall18LeanToBackWallAngle = 101.935;
Stall19LeanToBackWallAngle = 108.282;
Stall20LeanToBackWallAngle = 114.629;
Stall18LeanToCrossFloorLength = 188.0831;
OfficeDoorPos = 11;
LeanToDoorWidth = 40;
LeanToDoorHeight = 96;
Stall17LeanToBackWallLength = 354.7693;
Stall19LeanToCrossFloorLength = 285.0823;
Stall18LeanToBackWallLength = 361.0327;
ToolRoomDoorPos = 89;
MatlDoorPos = 16.5;
Stall20LeanToCrossFloorLength = 431.5906;
MatlRoomDivWallPosOnStall20 = 231;
MatlRoomDivWallPosOnStall21 = 312;
MatlRoomDoorPos = 64;
LeanToInteriorWallHeight = 119;

// Lean-To Roof Data
LeanToRoofHeightAtStall17 = 148;
LeatToRoofHeightAtStall20 = 200;
LeanToRoofHeightAtEaves = 128;

// Stall 1 Back Wall Data
Stall1BackWallLength = 373.7929;
Stall1To6BackWallHeight = 384;
WallCornerAngle = 43.413;
WallJointAngle = 86.826;
Stall1To6BackWallWindowWidth = 261.8969;
Stall1To20BackWallLowerWindowHeight = 173.5;
Stall1To20BackWallUpperWindowHeight = 53.5;
Stall1BackWindowHPos = 55.948;
Stall1To20BackWallLowerWindowVPos = 30.5;
Stall1To20BackWallUpperWindowVPos = 240.5;
WallInset = 7;
Stall1To6BackWallWindowLedgeLength = 265.5;
Stall1To20BackWallWindowLedgeHeight = 14.5;
Stall1To20BackWallLowerWindowLedgeVPos = 30;
Stall1To20BackWallUpperWindowLedgeVPos = 240;
Stall1BackWallWindowLedgeHPos = 54.1465;
Stall1BackWallInsetWidth = 310.7929;
Stall1To20BackWallInsetHeight = 321;
Stall1BackWallInsetPos = 31.5;
TCCornerBlockWidth = 15;
TCCornerBlockHeight = 24;
TCCornerBlockProj = 0.75;
WindowPostWidth = 11;
Stall1BackWallWindowFramePos = 3;
Stall1To6BackWallPostSpacing = 55.2244;
Stall1To6BackWallWFWidth = 55.2244;
Stall1To6BackWallWindowPaneWidth = 8.4448;
Stall1To6BackWallLowerWFHeight = 85;
Stall1To6BackWallUpperWFHeight = 47.5;
Stall1To6BackWallLowerWindowPaneHeight = 11.6667;
WindowBackingWidth = 2;
Stall1To6BackWallUpperWindowPaneHeight = 12.8333;
Stall1To20BackWallTotalBoardJointWidth = 5.5;
Stall1To6BackWallBoardWidth = 4.1437;
Stall1To6BackWallJointWidth = 0.5;
Stall1To6BackWallRoofLine = 351;
Stall1BackWallRidgeSpacing = 14.3574;
RidgeSize = 1;
CopingHeight = 6;
CopingWidth = 19;
CopingOverhang = 1.5;

// Stall 2-5 Back Wall Data
Stall2To5BackWallLength = 358.4398;
Stall2To5BackWallWindowHPos = 48.2713;
WindowLedgeHPos = 155.0843;
Stall2To5BackWallInsetWidth = 322.4398;
Stall2To20BackWallInsetPos = 18;
BackInsetThickness = 6;
Stall2To5BackWallRidgeSpacing = 13.7669;

// Stall 6 Back Wall Data
Stall6BackWallLength = 374.4642;
Stall6BackWallRidgeSpacing = 14.3832;
Stall6SideWallDoorHeight = 90;
Stall6SideWallLowerWindowHeight = 84;
Stall6SideWallUpperWindowHeight = 54;
Stall6SideWallLowerWindowVPos = 117;
Stall6SideWallUpperWindowVPos = 240;
Stall6SideWallDoorFrameWidth = 76;
Stall6SideWallDoorFrameHeight = 87;
Stall6SideWallLowerWFWidth = 32.5;
Stall6SideWallLowerWFHeight = 78;
Stall6SideWallUpperWFWidth = 32.5;
Stall6SideWallUpperWFHeight = 47.5;
Stall6SideWallWindowLedgeLength = 88.5;
Stall6SideWallLowerWindowLedgeVPos = 116.5;
Stall6SideWallUpperWindowLedgeVPos = 239.5;
Stall6SideWallWindowLedgeHPos = 54.75;
Stall6SideDoorWindowWidth = 30.85;
Stall6SideDoorWindowHeight = 32;
Stall6SideDoorWindowHPos = 9.47;
Stall6SideDoorWindowHSpacing = 8.7874;
Stall6SideDoorWindowVPos = 45;
Stall6SideDoorThickness = 3;
Stall6SideWallRidgeSpacing = 15.8141;
Stall6SideWallFirstRidgePos = 14;
Stall6And7WallCornerAngle = 46.587;

// Stall 7 Back Wall Data
Stall7BackWallLength = 318.2791;
Stall7To20BackWallHeight = 399;
Stall7To20BackWallWindowWidth = 249;
Stall7BackWallWindowHPos = 34.6395;
Stall7To20BackWallWindowLedgeLength = 253.5;
Stall7BackWallWindowLedgeHPos = 32.3895;
Stall7BackWallInsetWidth = 282.2791;
Stall7To20BackWallPostSpacing = 52;
Stall7To20BackWallWFWidth = 52;
Stall7To20BackWallWindowPaneWidth = 7.8;
Stall7To20BackWallLowerWFHeight = 85;
Stall7To20BackWallUpperWFHeight = 47.5;
Stall7To20BackWallLowerWindowPaneHeight = 11.6667;
Stall7To20BackWallUpperWindowPaneHeight = 12.8333;
Stall7To20BackWallBoardWidth = 3.875;
Stall7BackWallInnerWallLength = 332.5291;
Stall7BackWallRidgeSpacing = 12.8386;
DividingWallWidthAtPosts = 16;
DividingWallDepthAtStallWall = 6;

// Stall 8-16 Back Wall Data
Stall8To20BackWallLength = 334.3035;
Stall8To20BackWallWindowHPos = 42.652;
Stall8To20BackWallWindowLedgeHPos = 40.402;
Stall8To20BackWallInsetWidth = 298.3035;
Stall8To20BackWallInnerWallLength = 332.5291;
Stall8To20BackWallRidgeSpacing = 13.3521;

// Stall 1 Side Wall Data
Stall1SideWallCol7Width = 48;
Stall1SideWallCol6Width = 56;
Stall1SideWallCol5Width = 32;
Stall1SideWallCol4Width = 32;
Stall1SideWallCol3Width = 32;
Stall1SideWallCol2Width = 32;
Stall1SideWallCol1Width = 32;
Stall1SideWallInset6Width = 180.4374;
Stall1SideWallInset5Width = 210;
Stall1SideWallInset4Width = 210;
Stall1SideWallInset3Width = 180.4374;
Stall1SideWallInset2Width = 180.4374;
Stall1SideWallInset1Width = 180.4374;
Stall1SideWallLengthBackSection = 526.437;
Stall1SideWallLengthMiddleSection = 454.437;
Stall1SideWallLengthFrontSection = 424.874;
Stall1SideWallSection7WallHeight = 384;
Stall1SideWallSection6WallHeight = 399;
Stall1SideWallSection5WallHeight = 414;
Stall1SideWallSection4WallHeight = 429;
Stall1SideWallSection3WallHeight = 303;
Stall1SideWallSection2WallHeight = 285;
Stall1SideWallSection1WallHeight = 270;
Stall1SideWallSection7Length = 205.75;
Stall1SideWallSection6Length = 200;
Stall1SideWallSection5Length = 179;
Stall1SideWallSection4Length = 180;
Stall1SideWallSection3Length = 201;
Stall1SideWallSection2Length = 217;
Stall1SideWallSection1Length = 223;
Stall1SideWallSection4Overhang = 8.1875;
Stall1SideWallSection1Overhang = 7.25;
Stall1SideWallInset6Height = 321;
Stall1SideWallInset5Height = 336;
Stall1SideWallInset4Height = 336;
Stall1SideWallInset3Height = 240;
Stall1SideWallInset2Height = 240;
Stall1SideWallInset1Height = 240;
Stall1SideWallInset6WindowWidth = 93.4374;
Stall1SideWallInset6LwrWinHeight = 81;
Stall1SideWallInset6UpperWinHeight = 57;
Stall1SideWallInset6WinHPos = 15;
Stall1SideWallInset6LwrWinVPos = 132;
Stall1SideWallInset6UpperWinVPos = 240;
Stall1SideWallInset6LedgeLength = 95;
Stall1SideWallWindowLedgeHeight = 14.5;
Stall1SideWallWindowLedgeProjection = 3;
Stall1SideWallInset6LwrLedgeVPos = 131.5;
Stall1SideWallInset6UpperLedgeVPos = 239.5;
Stall1SideWallInset6LedgeHPos = 14.2187;
Stall1SideWallInset6DoorWidth = 53.4374;
Stall1SideWallInset6DoorHeight = 111;
Stall1SideWallInset6DoorPos = 15;
Stall1SideWallInset5WindowWidth = 162;
Stall1SideWallInset5LwrWinHeight = 93;
Stall1SideWallInset5UpperWinHeight = 72;
Stall1SideWallInset5WinHPos = 24;
Stall1SideWallInset5LwrWinVPos = 123;
Stall1SideWallInset5UpperWinVPos = 243;
Stall1SideWallInset5LedgeLength = 164;
Stall1SideWallInset5LwrLedgeVPos = 122.5;
Stall1SideWallInset5UpperLedgeVPos = 242.5;
Stall1SideWallInset5LedgeHPos = 23;
Stall1SideWallInset5DoorWidth = 122;
Stall1SideWallInset5DoorHeight = 93;
Stall1SideWallInset5DoorPos = 24;
Stall1SideWallInset4WindowWidth = 162;
Stall1SideWallInset4LwrWinHeight = 186;
Stall1SideWallInset4UpperWinHeight = 72;
Stall1SideWallInset4WinHPos = 24;
Stall1SideWallInset4LwrWinVPos = 33;
Stall1SideWallInset4UpperWinVPos = 243;
Stall1SideWallInset4LedgeLength = 164;
Stall1SideWallInset4LwrLedgeVPos = 32.5;
Stall1SideWallInset4UpperLedgeVPos = 242.5;
Stall1SideWallInset4LedgeHPos = 23;
Stall1SideWallInset321WindowWidth = 162;
Stall1SideWallInset321WindowHeight = 186;
Stall1SideWallInset321WindowHPos = 9.2187;
Stall1SideWallInset321WindowVPos = 33;
Stall1SideWallInset321LedgeLength = 164;
Stall1SideWallInset321LedgeVPos = 32.5;
Stall1SideWallInset321LedgeHPos = 8.2187;
Stall1SideWallSideWindowPostWidth = 9;
Stall1SideWallInset6PostSpacing = 38.2187;
Stall1SideWallInset54PostSpacing = 45.3335;
Stall1SideWallInset321PostSpacing = 45.3335;
Stall1SideWallInset6WFWidth = 38.2187;
Stall1SideWallInset54WFWidth = 45.3335;
Stall1SideWallInset5DoorWFWidth = 104;
Stall1SideWallInset321WFWidth = 45.3335;
Stall1SideWallInset6WindowPaneWidth = 9.7396;
Stall1SideWallInset54WindowPaneWidth = 8.5833;
Stall1SideWallInset5DoorWindowPaneWidth = 8.1;
Stall1SideWallInset321WindowPaneWidth = 8.5833;
Stall1SideWallInset6LwrWFHeight = 75;
Stall1SideWallInset5LwrWFHeight = 87;
Stall1SideWallInset5DoorWFHeight = 32;
Stall1SideWallInset5DoorWFVPos = 53;
Stall1SideWallInset4LwrWFTopHeight = 91.25;
Stall1SideWallInset4LwrWFBtmHeight = 91.25;
Stall1SideWallInset321WFTopHeight = 91.25;
Stall1SideWallInset321WFBtmHeight = 91.25;
Stall1SideWallInset6UpperWFHeight = 51;
Stall1SideWallInset54UpperWFHeight = 66;
Stall1SideWallInset6LwrWindowPaneHeight = 12.4;
Stall1SideWallInset5LwrWindowPaneHeight = 12;
Stall1SideWallInset5DoorWindowPaneHeight = 12.5;
Stall1SideWallInset4LwrWindowPaneHeight = 12.7083;
Stall1SideWallInset321WindowPaneHeight = 12.7083;
Stall1SideWallInset6UpperWindowPaneHeight = 14;
Stall1SideWallInset54UpperWindowPaneHeight = 13.75;
Stall1SideWallSect7RidgeSpacing = 19.0893;
Stall1SideWallSect6RidgeSpacing = 18.1818;
Stall1SideWallSect5RidgeSpacing = 17.9;
Stall1SideWallSect4RidgeSpacing = 19.691;
Stall1SideWallSect3RidgeSpacing = 20.7;
Stall1SideWallSect2RidgeSpacing = 19.7273;
Stall1SideWallSect1RidgeSpacing = 18.75;
Stall1SideWallSect7FirstRidgePos = 15.9429;
Stall1SideWallInnerWallOuterWallOffset = 16.9119;
Stall1SideWallBackRoofLineAtSect4 = 416.8937;
Stall1SideWallFrontRoofLineAtSect4 = 294;
Stall1SideWallFrontRoofLine = 246;
Stall1SideWallBackInsetBlankHeight = 63;
Stall1SideWallDoorThickness = 4;
Stall1SideWallBoardThickness = 0.5;
Stall1SideWallBackBoardInset = 2;
Stall1SideWallInset5DoorPanelWidth = 125.5;
Stall1SideWallInset5BoardWidth = 5.5;
Stall1SideWallBoardGap = 0.5;
Stall1SideWallInset4BackInsetBlankHeight = 18;
Stall1SideWallInset4BackHInset = 30;
Stall1SideWallDropWallAtInset4SetBack = 2.75;
Stall1SideWallFrontWallSetBack = 6;

// Stall 27 Side Wall Data
Stall27Col1Width = 31.5;
Stall27Col2Width = 31.5;
Stall27Col3Width = 31.5;
Stall27Col4Width = 31.5;
Stall27Col5Width = 31.5;
Stall27Col6Width = 16;
Stall27Col7Width = 16;
Stall27Col8Width = 16;
Stall27Col6Height = 336;
Stall27Col7Height = 322;
Stall27Col8Height = 309;
Stall27Col678Thickness = 22;
Stall27Inset1Length = 180;
Stall27Inset2Length = 180;
Stall27Inset3Length = 180;
Stall27Inset4Length = 204;
Stall27Inset5Length = 383.7126;
Stall27Inset6Length = 250;
Stall27Inset7Length = 253.1709;
Stall27Inset1Height = 240;
Stall27Inset2Height = 240;
Stall27Inset3Height = 240;
Stall27Inset4Height = 336;
Stall27Inset5Height = 336;
Stall27Section1Length = 223;
Stall27Section2Length = 217;
Stall27Section3Length = 201;
Stall27Section4Length = 180;
Stall27Section5Length = 179;
Stall27Section6Length = 298.213;
Stall27Section7Length = 260;
Stall27Section8Length = 278.1709;
Stall27Section1Height = 270;
Stall27Section2Height = 285;
Stall27Section3Height = 303;
Stall27Section4Height = 429;
Stall27Section5Height = 414;
Stall27Section6Height = 399;
Stall27Section7Height = 384;
Stall27Section8Height = 363;
Stall27Inset1WindowHPos = 15.5;
Stall27Inset2WindowHPos = 39.5;
Stall27Inset3WindowHPos = 15.5;
Stall27Inset4WindowHPos = 23.5;
Stall27Inset5WindowHPos = 23.5;
Stall27Inset6GBWindowHPos = 57.25;
Stall27Inset6WindowHPos = 51;
Stall27Inset7GBWindowHPos = 49;
Stall27Inset7WindowHPos = 42.5;
Stall27Inset1To4And6WindowLwrVPos = 33;
Stall27Inset5LwrWindowVPos = 126;
Stall27Inset6WindowVPos = 38.5;
Stall27Inset7GBWindowVPos = 146.5;
Stall27Inset45UpperWindowVPos = 243;
Stall27Inset5DoorHPos = 62.5;
Stall27Inset123WindowOpeningWidth = 128;
Stall27Inset123WindowOpeningHeight = 186;
Stall27Inset123PostWidth = 13;
Stall27Inset123WindowLedgeLength = 133.5;
Stall27Inset123WFWidth = 53.5;
Stall27Inset123WFHeight = 180;
Stall27Inset123WFTopHeight = 91.25;
Stall27Inset123WFBtmHeight = 91.25;
Stall27Inset123WinPaneHCount = 5;
Stall27Inset123WinPaneTopVCount = 6;
Stall27Inset123WinPaneBtmVCount = 6;
Stall27Inset123WindowPaneWidth = 8.1;
Stall27Inset123TopWindowPaneHeight = 12.7083;
Stall27Inset123BtmWindowPaneHeight = 12.7083;
Stall27Inset45WindowOpeningWidth = 161;
Stall27Inset4LwrWindowOpeningHeight = 186;
Stall27Inset45UpperWindowOpeningHeight = 72;
Stall27Inset45PostWidth = 9;
Stall27Inset45WindowLedgeLength = 163.5;
Stall27Inset45WFWidth = 45;
Stall27Inset4LwrWFHeight = 180;
Stall27Inset45UpperWFHeight = 66;
Stall27Inset4LwrWFTopHeight = 91.25;
Stall27Inset4LwrWFBtmHeight = 91.25;
Stall27Inset45WinPaneHCount = 4;
Stall27Inset4WinPaneTopVCount = 6;
Stall27Inset4WinPaneBtmVCount = 6;
Stall27Inset45UpperWinPaneVCount = 4;
Stall27Inset45WindowPaneWidth = 8.5;
Stall27Inset4LwrTopWindowPaneHeight = 12.7083;
Stall27Inset4LwrBtmWindowPaneHeight = 12.7083;
Stall27Inset45UpperWindowPaneHeight = 13.75;
Stall27Inset5LwrWindowOpeningHeight = 93;
Stall27Inset5LwrWFHeight = 87;
Stall27Inset5LwrWinPaneVCount = 6;
Stall27Inset5LwrWindowPaneHeight = 12;
Stall27Inset5DoorOpeningWidth = 122;
Stall27Inset5DoorOpeningHeight = 93;
Stall27Inset6GBWindowHCount = 15;
Stall27Inset6GBWindowWidth = 135.5;
Stall27Inset6GBWindowVCount = 26;
Stall27Inset6GBWindowHeight = 234.5;
Stall27Inset7GBWindowHCount = 13;
Stall27Inset7GBWindowWidth = 117.5;
Stall27Inset7GBWindowVCount = 14;
Stall27Inset7GBWindowHeight = 126.5;
Stall27Inset7DoorOpeningWidth = 128;
Stall27Inset7DoorOpeningHeight = 114;
Stall27Inset67HorizBeamHeight = 36;
Stall27Inset67HorizBeamThickness = 19;
Stall27Col8WallAngle = 43.4133;
Stall27FrontWallSectionLength = 634.5;
Stall27MidWallSectionLength = 650.7126;
Stall27BackWallSectionLength = 551.1693;
Stall27Section3OnMidSection = 6.5;
Stall27Section6OnBackSection = 13;
Stall27FrontWallPos = 611.7165;
Stall27ConcreteSillWidth = 22;
Stall27Col8Overhang = (Stall27Col678Thickness - WallThickness)/tan(Stall27Col8WallAngle);

// Stall 7-8/15-16 Dividing Wall Data
Post1LocationAlongWall = 213.713;
Post2LocationAlongWall = 428.3898;
Post3LocationAlongWall = 569.5197;
Post4LocationAlongWall = 639.0906;
Post5LocationAlongWall = 1148.9449;
DivWallThickness = 9;
DivWallPostThickness = 16;
DivWallPostWidth = 35;
DivWallBackPostWidth = 16.975;
DivWallFrontPostWidth = 17.514;
DivWallDoorWidth = 120;
DivWallPost4Spacing = 238.2142;
DivWallPost3Spacing = 201.7142;
DivWallPost2Spacing = 180;
DivWallPost1Spacing = 180;
DivWallPost1FromFrontPost = 174;
DivWallBackInset = 6;
WallLengthBackSection = 354.9811;
WallLengthMiddleSection = 381;
WallLengthFrontSection = 418.2953;
DivWallSection6Length = 169.9811;
DivWallSection1Length = 201.2961;
Section4Overhang = 8.1875;
Section1Overhang = 7.25;
Sect6RidgeSpacing = 15.4528;
Sect5RidgeSpacing = 17.9;
Sect4RidgeSpacing = 19.691;
Sect3RidgeSpacing = 20.7;
Sect2RidgeSpacing = 19.7273;
Sect1RidgeSpacing = 16.9413;
BackLengthAlongWallToMez = 511.1181;
FrontLengthAlongWallToMez = 645.1732;
RoofThickness = 28;
DivWallInset = 3.5;
DivWallInsetAHeight = 318;
DivWallInsetBHeight = 330;
DivWallInsetCHeight = 330;
DivWallInsetDHeight = 233;
DivWallInsetEHeight = 233;
DivWallInsetFHeight = 233;

// Mezzanine Wall Data
MezWallStall1And27OutsideWallWidth = 275.2689;
MezWallStall1And27InsideWallWidth = 276.1587;
MezWallStall2To26OutsideWidth = 275.9378;
MezWallStall2To26InsideWidth = 276.8248;
MezWallOutsideWallHeight = 109.1531;
MezWallInsideWallHeight = 107.8988;
MezWallOffsetFromOutsideToInsideTop = 0.681;
MezWallThickness = 8;
MezWallStall1And27WindowHPos = 12.1345;
MezWallStall2To26WindowHPos = 12.4689;
MezWallWindowVPos = 18;
MezWallWindowCenterOffset = 2;
MezWallWindowWidth = 57.5;
MezWallOpeningWidth = 251;
MezWallOpeningHeight = 69;
MezWallWindowPostWidth = 7;
MezWallPostSpacing = 57.5;
MezWallWFWidth = 49.5;
MezWallWFHeight = 63;
MezWallWindowPaneWidth = 7.3;
MezWallWindowPaneHeight = 13;

// Stall 17-20 Back Wall Data
Stall17To20WallLength = 334.3035;
Stall20WallLength = 318.2778;
Stall17To20WallInsetLength = 300;
Stall17To20WallInsetPos = 17.1518;
Stall20WallInsetPos = 1.126;
GlassBlockSize = 8.5;
GlassBlockThickness = 3;
Stall17To20PostWidth = 16;
Stall17To20SideWindowTrimWidth = 5;
GBWindowOpeningHeight = 6;
GBWindowOpeningWidth = 5;
Stall17To20WindowOpeningHeight = 54.5;
Stall17To20WindowOpeningWidth = 45.5;
Stall17To20WindowPaneWidth = 9.5;
Stall17To20WindowPaneHeight = 20.75;
Stall17GBVCount = 15;
Stall17GlassOpeningHeight = 141;
Stall17To20ConcreteSillWidth = 15;
Stall17To20ConcreteSillHeight = 5.5;
Stall17GlassOpeningVPos = 162;
Stall18GBVCount = 14;
Stall18GlassOpeningHeight = 132;
Stall18GlassOpeningVPos = 171;
Stall19GBVCount = 13;
Stall19GlassOpeningHeight = 123;
Stall19GlassOpeningVPos = 180;
Stall20GBVCount = 6;
Stall20GlassOpeningHeight = 60;
Stall20GlassOpeningVPos = 243;
Stall17To20GlassOpeningWidth = 287;
Stall17To20GBHCount = 15;
Stall17To20PostPos = 135.5;
Stall17To20GlassOpeningHPos = 23.6518;
Stall17To20GlassBlockSetBack = 10.5;
Stall17To20WindowHPos = 45;
Stall17WindowVPos = 86.5;
GlassBlockCoreThickness = 2;
Stall18ToolRoomDoorPos = 23;
Stall18ToolRoomWindowHPos = 70;
Stall18ToolRoomWindowVPos = 40;
Stall18ToolRoomWindowWidth = 126;
Stall18ToolRoomWindowHeight = 70;
Stall19ToolRoomDoorPos = 101.5189;
Stall19ToolRoomWindowHPos = 159.5189;
Stall19ToolRoomWindowVPos = 40;
Stall19ToolRoomWindowWidth = 62;
Stall19ToolRoomWindowHeight = 70;
Stall19InteriorWallPos = 235.3197;
Stall19InteriorWallAngle = 68.5441;
Stall19MatlRoomDoorPos = 247.0189;
Stall20InteriorWallPos = 101.2575;
Stall2021WallCornerAngle = 46.5846;
Stall20InteriorWallAngle = 128.554;
Stall21InteriorWallAngle = 35.3802;
Stall20InsideWallLength = 332.5291;
Stall21Post3ToInteriorWall = 141.5;
Stall20InsideOffset = 15.1386;

// Stall 21-27 Back Wall Data
Stall21To27BackWallInsideLength = 403.6181;
Stall27BackWallLength = 428.0906;
Stall22To26WallLength = 406.0551;
Stall27BackWallCornerPostWidth = 16;
Stall21To27BackWallPostThickness = 22;
Stall21To27BackWallHeight = 309;
Stall21To26BackWallConcretePostWidth = 11;
Stall21To27BWGBWindowVCount = 26;
Stall21To27BackWallGBWindowHeight = 234.5;
Stall21To27BWGBWindowHCount = 17;
Stall21To27BackWallGBWindowWidth = 153.5;
Stall21To27BackWallWindowPostWidth = 17;
Stall21To27BackWallHorizBeamHeight = 36;
Stall21To27GBWindowVPos = 33;
Stall21To27BackWallHorizBeamThickness = 19;
Stall21SideWallInsideLength = 642.0512;
Stall21BackWallInsideLength = 403.6181;
Stall21SWInset1GBWindowHCount = 15;
Stall21SideWallInset1GBWindowWidth = 135.5;
Stall21SWInset2GBWindowHCount = 19;
Stall21SideWallInset2GBWindowWidth = 171.5;
Stall21SWInset3GBWindowHCount = 8;
Stall21SideWallInset3GBWindowWidth = 72.5;
Stall21SWInset1GBWindowVCount = 10;
Stall21SideWallInset1GBWindowHeight = 90.5;
Stall21SWInset2GBWindowVCount = 9;
Stall21SideWallInset2GBWindowHeight = 81.5;
Stall21SWInset3GBWindowVCount = 9;
Stall21SideWallInset3GBWindowHeight = 81.5;
Stall21SideWallInset1GBWindowHPos = 41;
Stall21SideWallInset2GBWindowHPos = 29.5;
Stall21SideWallInset3GBWindowHPos = 22.25;
Stall21SideWallInset1GBWindowVPos = 156;
Stall21SideWallInset2GBWindowVPos = 192;
Stall21SideWallInset3GBWindowVPos = 207;
Stall21SideWallInset1Length = 217.5;
Stall21SideWallInset2Length = 230.5;
Stall21SideWallInset3Length = 117;
Stall21SideWallPost1Width = 34;
Stall21SideWallPost23Width = 16;
Stall21SideWallPostThickness = 22;
Stall21SideWallPost2Height = 315;
Stall21SideWallPost3Height = 330;
Stall21SideWallOutsideLength = 650.1653;
Stall21SideWallBackWallAngle = 43.4132;
Stall21BackWallOutsideLength = Stall21BackWallInsideLength + 
                                Stall21To27BackWallPostThickness * tan(StallAngle/2) + 
                                Stall21To27BackWallPostThickness/tan(Stall21SideWallBackWallAngle);

// Lean-To Wall Data
Stall17LeanToInteriorBackWallLength = 337.9177;
Stall17LeanToInteriorSideWallLength = 120.0291;
Stall18LeanToInteriorBackWallLength = 371.5677;
Stall19LeanToInteriorBackWallLength = 399.9173;
Stall20LeanToInteriorBackWallLength = 423.6535;
LeanToInteriorWallLength = 1533.0551;
Stall17LeanToSideWallRHWallAngle = 93.1735;
Stall20LeanToBackWallRHSideWallAngle = 59.0236;
LeanToSideWallBackWallAngle = 95.5884;
LeanToPostWidth = 24;
LeanToWallThickness = 12;
LeanToPostThickness = 16;
LeanToInset1Length = 379;
LeanToInset2Length = 379;
LeanToInset3Length = 347.5;
LeanToInset4Length = 331.9528;
LeanToConcreteSillHeight = 5.5;
LeanToConcreteSillWidth = 16;
LeanToConcreteSillLength = 90;
LeanToConcreteHeaderHeight = 12;
LeanToConcreteHeaderLength = 106;
LeanToTopRailHeight = 2;
LeanToBottomRailHeight = 2;
LeanToCheckRailHeight = 2;
LeanToStileWidth = 2;
LeanToStileDepth = 2.5;
LeanToMuntinWidth = 2;
LeanToMuntinDepth = 2;
LeanToSideJambWidth = 3;
LeanToHeadJambWidth = 3;
LeanToSillWidth = 3;
LeanToJambDepth = 6;
LeanToWindowBackingWidth = 2;
LeanToWindowBackingDepth = 4;
LeanToOfficeWindowHeight = 75;
LeanToOfficeUpperFrameHeight = 35.5;
LeanToOfficeLowerFrameHeight = 35.5;
LeanToWindowWidth = 42;
LeanToWindowPostWidth = 6;
LeanToOfficeWindowSpacing = 60;
LeanToWallHeight = 120;
LeanToToolRoomWindowHeight = 45;
LeanToToolRoomUpperFrameHeight = 20.5;
LeanToToolRoomLowerFrameHeight = 20.5;
LeanToSideWallHeightAtRH = 141;
LeanToOfficeWindowHPos = 80.2445;
LeanToOfficeWindowVPos = 33.5;
LeanToShortWindowVPos = 63;
LeanToToolRoomWindowsHPos = 81.5;
LeanToMatlRoomWindowInset3HPos = 65.75;
LeanToMatlRoomWindowInset4HPos = 57.9764;
LeanToSideWallInsetLength = 110.1547;
LeanToSideWallWindowHPos = 34.0774;
LeanToSideWallInsetPos = 20.3723;

// Stall 21-22 Dividing Wall Data
Stall2122DivWallBackPostWidth = 16.9875;
Stall2122DivWallFrontPostWidth = 16.69;
Stall2122DivWallPostWidth = 35;
Stall2122DivWallPost5Width = 46.1874;
Stall2122DivWallInset1Length = 174;
Stall2122DivWallInset2Length = 180;
Stall2122DivWallInset3Length = 180.6902;
Stall2122DivWallInset4Length = 199.3799;
Stall2122DivWallInset5Length = 200;
Stall2122DivWallInset6Length = 204.3098;
Stall2122DivWallInset7Length = 180;
Stall2122DivWallInset8Length = 182;
Stall2122DivWallInset1Height = 233;
Stall2122DivWallInset2Height = 233;
Stall2122DivWallInset3Height = 233;
Stall2122DivWallInset4Height = 330;
Stall2122DivWallInset5Height = 330;
Stall2122DivWallInset6Height = 318;
Stall2122DivWallInset7Height = 252;
Stall2122DivWallInset8Height = 252;
Stall2122DivWallPostThickness = 16;
Stall2122DivWallThickness = 9;
Stall2122DivWallDoorWidth = 120;
Stall2122DivWallDoorHeight = 133;
Stall2122DivWallSection1Length = 217;
Stall2122DivWallBackSectionBaseLength = 535.1693;
Stall2122DivWallBackSectionLength = 551.1693;
Stall2122DivWallMidSectionLength = 643.7126;
Stall2122DivWallFrontSectionBaseLength = 617.3622;
Stall2122DivWallFrontSectionLength = 637.1102;
Stall2122DivWallInset = 3.5;
Stall2122DivWallRegistrationTabWidth = 3;
Stall2122DivWallRegistrationTabDepth = 3;
Stall2122DivWallMezWallPocketVPos = 293.3299;
Stall2122DivWallMezWallPocketHPos = 1150.8701;
Stall2122DivWallMezWallPocketBackHeight = 108.4591;
Stall2122DivWallMezWallPocketFrontHeight = 109.713;
Stall2122DivWallMezWallPocketWidth = 8.56;
Stall2122DivWallMezWallPocketTopOffset = 0.681;
Stall2122DivWallInset3OnMidSection = 4.0188;
