include <BrickPattern-for-OpenSCAD/brickpattern.scad>;
include <Chamfers-for-OpenSCAD/Chamfer.scad>;
include <./RHMaster.scad>;

function toInches(dimension) = dimension * 25.4;

difference(){
    scale([HOScale,HOScale,HOScale]){
        union(){
            // Apply wall below windows
            translate ([toInches(LeanToSideWallInsetPos), toInches(-BrickWidth), 0])
                scale([MMtoInches, MMtoInches, MMtoInches])
                    brickpattern(length = LeanToSideWallInsetLength,
                                 height = LeanToShortWindowVPos, 
                                 brickwidth = BrickLength, 
                                 brickheight = BrickHeight, 
                                 brickthickness = BrickWidth + epsilon, 
                                 mortar = MortarWidth,
                                 shift = 0, 
                                 rand = 0, 
                                 chamfer = MortarWidth);
                                 
            // Apply brick to wall above windows
            translate ([toInches(LeanToSideWallInsetPos), 
                        toInches(-BrickWidth), 
                        toInches(LeanToShortWindowVPos + 
                                    LeanToToolRoomWindowHeight)])
                scale([MMtoInches, MMtoInches, MMtoInches])
                    brickpattern(length = LeanToSideWallInsetLength,
                                 height = LeanToSideWallHeightAtRH - 
                                            (LeanToShortWindowVPos + 
                                            LeanToToolRoomWindowHeight), 
                                 brickwidth = BrickLength, 
                                 brickheight = BrickHeight, 
                                 brickthickness = BrickWidth + epsilon, 
                                 mortar = MortarWidth,
                                 shift = 0, 
                                 rand = 0, 
                                 chamfer = MortarWidth);
            
            // Apply brick to wall left of windows
            translate ([toInches(LeanToSideWallInsetPos), 
                        toInches(-BrickWidth), 
                        toInches(LeanToShortWindowVPos)])
                scale([MMtoInches, MMtoInches, MMtoInches])
                    brickpattern(length = (LeanToSideWallInsetLength - 
                                            (LeanToWindowWidth * 2 + 
                                            LeanToWindowPostWidth))/2,
                                 height = LeanToToolRoomWindowHeight, 
                                 brickwidth = BrickLength, 
                                 brickheight = BrickHeight, 
                                 brickthickness = BrickWidth + epsilon, 
                                 mortar = MortarWidth,
                                 shift = 1, 
                                 rand = 0, 
                                 chamfer = MortarWidth);
            
            // Apply brick to wall right of windows
            translate ([toInches(LeanToSideWallInsetPos + 
                                    (LeanToWindowWidth * 2 + 
                                     LeanToWindowPostWidth) + 
                                     ((LeanToSideWallInsetLength - 
                                      (LeanToWindowWidth * 2 + 
                                       LeanToWindowPostWidth))/2)), 
                        toInches(-BrickWidth), 
                        toInches(LeanToShortWindowVPos)])
                scale([MMtoInches, MMtoInches, MMtoInches])
                    brickpattern(length = (LeanToSideWallInsetLength - 
                                            (LeanToWindowWidth * 2 + 
                                            LeanToWindowPostWidth))/2,
                                 height = LeanToToolRoomWindowHeight, 
                                 brickwidth = BrickLength, 
                                 brickheight = BrickHeight, 
                                 brickthickness = BrickWidth + epsilon, 
                                 mortar = MortarWidth,
                                 shift = 0, 
                                 rand = 0, 
                                 chamfer = MortarWidth);
            
            // Apply brick to post between windows
            translate ([toInches(LeanToSideWallInsetPos + 
                                    ((LeanToSideWallInsetLength - 
                                      (LeanToWindowWidth * 2 + 
                                       LeanToWindowPostWidth))/2) + 
                                      LeanToWindowWidth), 
                        toInches(-BrickWidth), 
                        toInches(LeanToShortWindowVPos)])
                scale([MMtoInches, MMtoInches, MMtoInches])
                    brickpattern(length = LeanToWindowPostWidth,
                                 height = LeanToToolRoomWindowHeight, 
                                 brickwidth = BrickLength, 
                                 brickheight = BrickHeight, 
                                 brickthickness = BrickWidth + epsilon, 
                                 mortar = MortarWidth,
                                 shift = 0, 
                                 rand = 0, 
                                 chamfer = MortarWidth);
            
            // Apply brick to column at left of wall
            translate ([toInches(-(LeanToPostThickness - 
                                    LeanToWallThickness) /
                                    tan(LeanToSideWallBackWallAngle/2)), 
                        toInches(LeanToWallThickness - 
                                    LeanToPostThickness - 
                                    BrickWidth), 
                        0])
                scale([MMtoInches, MMtoInches, MMtoInches])
                    brickpattern(length = LeanToPostWidth + MortarWidth/2,
                                 height = LeanToSideWallHeightAtRH, 
                                 brickwidth = BrickLength, 
                                 brickheight = BrickHeight, 
                                 brickthickness = BrickWidth + epsilon, 
                                 mortar = MortarWidth,
                                 shift = 0, 
                                 rand = 0, 
                                 chamfer = MortarWidth);
            
            // Apply brick to right face of column
            translate ([toInches(LeanToSideWallInsetPos + MortarWidth), 
                        toInches(LeanToWallThickness - 
                                    LeanToPostThickness), 
                        0])
                rotate([0,0,90])
                    scale([MMtoInches, MMtoInches, MMtoInches])
                            brickpattern(length = 8, 
                                         height = LeanToSideWallHeightAtRH, 
                                         brickwidth = BrickLength, 
                                         brickheight = BrickHeight, 
                                         brickthickness = BrickWidth + epsilon,
                                         mortar = MortarWidth,
                                         shift = 0, 
                                         rand = 0,
                                         chamfer = MortarWidth);

            color("moccasin") 
                import("./STL Files/LeanToSideWall.stl");
        }
    }
            
    // Remove brick that extends above top of wall
    color("green") 
        import("./STL Files/LeanToSideWallDifferenceWedge.stl");
}